<?php
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    class MotoreDiRicercaTemplate extends MotoreDiRicerca {

	 // solo se viene fatta la ricerca per categorie bisogna distinguere se si tratta di una categoria di articoli
	 // o di una categoria di prodotti dell'ecommerce
        function generaQuery() {
            if(parent::getTipo()=="cercaProdotti") {
                $impostazioni  = parent::getImpostazioni();
                $chiaveRicerca = parent::getChiaveRicerca();
                if($impostazioni["rimuoviUltimaLettera"]) {
                    $chiaveRicerca = substr($chiaveRicerca, 0,-1);
                }
                $opzioneCategoria = isset($_GET["categoria"]) ? "AND categoria={$_GET["categoria"]} " : "";
                $elementiDaCercare = [];
                if($impostazioni["cercaProdottiPerNome"]=="si") {
                    array_push($elementiDaCercare,"nome");
                }
                if($impostazioni["cercaContenutiPerMetaDescrizione"]=="si") {
                    array_push($elementiDaCercare,"metaDescrizione");
                }
                if($impostazioni["cercaProdottiPerTesto"]=="si") {
                    array_push($elementiDaCercare,"descrizione");
                }
                if($impostazioni["cercaProdottiPerTestoDettagli"]=="si") {
                    array_push($elementiDaCercare,"testoDettagli");
                }
                if($impostazioni["cercaProdottiPerMarca"]=="si") {
                    array_push($elementiDaCercare,"marca");
                }
                if($impostazioni["cercaProdottiPerModello"]=="si") {
                    array_push($elementiDaCercare,"modello");
                }
                
                $stringaElementiDaCercare = $this->creaStringaQuery($elementiDaCercare,$chiaveRicerca);
                
                $queryRicerca = "SELECT * FROM geecEc_prodotti WHERE pubblicato LIKE 'si' AND ($stringaElementiDaCercare) $opzioneCategoria";
                parent::setQueryConteggio($queryRicerca);
                
                // aggiungo la paginazione
                if(isset($_GET["pag"])) {
		        $limiteInferiore = parent::getElementiPerPagina() * ($_GET["pag"] -1);
		        $queryRicerca .= " LIMIT $limiteInferiore, ".parent::getElementiPerPagina();
                }
                else {
		        $queryRicerca .= " LIMIT ".parent::getElementiPerPagina();
                }
                parent::setQueryRicerca($queryRicerca);
            }
            else if(parent::getTipo()=="cercaProdottiFornitore") {
		$chiaveRicerca  = parent::getChiaveRicerca();
		$datiFornitore = parent::getDb()->leggiSingolaRiga("geec_utenti",$chiaveRicerca,"organizzazione");
		$queryRicerca  = "SELECT * FROM geecEc_prodotti WHERE pubblicato LIKE 'si' AND idFornitore={$datiFornitore["id"]}";
		parent::setQueryConteggio($queryRicerca);
                
                // aggiungo la paginazione
                if(isset($_GET["pag"])) {
		        $limiteInferiore = parent::getElementiPerPagina() * ($_GET["pag"] -1);
		        $queryRicerca .= " LIMIT $limiteInferiore, ".parent::getElementiPerPagina();
                }
                else {
		        $queryRicerca .= " LIMIT ".parent::getElementiPerPagina();
                }
                parent::setQueryRicerca($queryRicerca);
            }
            else if(parent::getTipo()=="cercaProdottiPerMarca") {
		$chiaveRicerca = parent::getChiaveRicerca();
		$queryRicerca  = "SELECT * FROM geecEc_prodotti WHERE pubblicato LIKE 'si' AND marca LIKE '{$chiaveRicerca}'";
		parent::setQueryConteggio($queryRicerca);
		parent::setQueryRicerca($queryRicerca);
            }
            else if(parent::getTipo()=="prodottiPerMarcaECategoria") {
                $marca     = filter_input(INPUT_GET,"marca",FILTER_SANITIZE_ADD_SLASHES);
                $categoria = parent::getChiaveRicerca();
                $impostazioniAspetto = parent::getImpostazioniAspetto();
                
                // costruisco la stringa per l'ordinamento
                if($categoria["ordinamento"]=="Data di pubblicazione, dal più nuovo") {
                    $ordinamento = "ORDER BY dataInserimento DESC";
                }
                else if($categoria["ordinamento"]=="Data di pubblicazione, dal più vecchio") {
                    $ordinamento = "ORDER BY dataInserimento ASC";
                }
                else if($categoria["ordinamento"]=="Per titolo, crescente") {
                    $ordinamento = "ORDER BY nome ASC";
                }
                else if($categoria["ordinamento"]=="Per titolo, decrescente") {
                    $ordinamento = "ORDER BY nome DESC";
                }
                else {
                    $ordinamento = "";
                }

                $querySottoCategoria = "SELECT * FROM geec_categorie WHERE tipo LIKE 'ecommerce' AND categoriaMadre='{$categoria["id"]}'";
                $risSottoCategoria   = parent::getDb()->eseguiQueryLettura($querySottoCategoria);

                $stringaCat = "AND (categoria='{$categoria["id"]}' ";
                $this->stringaSottoCategorie = "";

                if($risSottoCategoria->num_rows>0) {
                   $this->stringaSottoCategorie .= "<div class=\"form-row sottocategorie mb-2\">";
                }
                while($sottoCategoria=$risSottoCategoria->fetch_assoc()) {

                    $link = GeneratoreUrl::creaUrlCategoria($sottoCategoria,$impostazioniAspetto["ottimizzazioneUrl"],$impostazioniAspetto["urlSito"]);

                    if($sottoCategoria["foto"]!="") {
                        $codiceSingolaSottoCategoria = "<div class=\"col-4 col-sm-3 col-xl-2 text-center mb-3\">
                                                            <a class=\"d-block pb-2 border-bottom border-primary\" href=\"$link\"><div class=\"background-image aspect-ratio-1-1 mb-2\" style=\"background: url('{$sottoCategoria["foto"]}');\">&nbsp;</div>
                                                              <strong>{$sottoCategoria["nome"]}</strong>
                                                            </a>
                                                        </div>";
                    }
                    else {
                        $codiceSingolaSottoCategoria = "<a class=\"btn btn-outline-primary mb-2 ml-2\" href=\"$link\" > {$sottoCategoria["nome"]}</a>";
                    }
                    $this->stringaSottoCategorie .= $codiceSingolaSottoCategoria;

                    $stringaCat .=" OR categoria={$sottoCategoria["id"]}";
                    //esegue una query simile per prendere le sottocategorie della sottocategoria
                    $querySottoCategorie = "SELECT * FROM geec_categorie WHERE categoriaMadre='{$sottoCategoria["id"]}'";
                    $risSottoCategoriaDellaSottocategoria = parent::getDb()->eseguiQueryLettura($querySottoCategorie);
                    while($sottoCategoriaDellaSottocategoria = $risSottoCategoriaDellaSottocategoria->fetch_assoc()) {
                        $stringaCat .=" OR categoria={$sottoCategoriaDellaSottocategoria["id"]}";
                    }
                }
                $stringaCat .=" )";
                if($risSottoCategoria->num_rows>0) {
                    $this->stringaSottoCategorie .= "</ul></div>";
                }
                $queryRicerca = "SELECT * FROM geecEc_prodotti WHERE pubblicato LIKE 'si' AND marca LIKE '$marca' $stringaCat $ordinamento";
                parent::setQueryConteggio($queryRicerca);

                // aggiungo la limitazione del sito
                if(isset($_GET["pag"])) {
                    $limiteInferiore = $categoria["numeroArticoliPerPagina"] * ($_GET["pag"] -1);
                    $queryRicerca .= " LIMIT $limiteInferiore, {$categoria["numeroArticoliPerPagina"]}";
                }
                else {
                    $queryRicerca .= " LIMIT {$categoria["numeroArticoliPerPagina"]}";
                }
                parent::setQueryRicerca($queryRicerca);
            }
            else if(parent::getTipo()=="categoria") {
                $categoria = parent::getChiaveRicerca();
                $impostazioniAspetto = parent::getImpostazioniAspetto();
                
                if($categoria["tipo"] == "ecommerce") {
                    // costruisco la stringa per l'ordinamento
                    if($categoria["ordinamento"]=="Data di pubblicazione, dal più nuovo") {
                        $ordinamento = "ORDER BY dataInserimento DESC";
                    }
                    else if($categoria["ordinamento"]=="Data di pubblicazione, dal più vecchio") {
                        $ordinamento = "ORDER BY dataInserimento ASC";
                    }
                    else if($categoria["ordinamento"]=="Per titolo, crescente") {
                        $ordinamento = "ORDER BY nome ASC";
                    }
                    else if($categoria["ordinamento"]=="Per titolo, decrescente") {
                        $ordinamento = "ORDER BY nome DESC";
                    }
                    else if($categoria["ordinamento"]=="Per prezzo, crescente") {
                        $ordinamento = "ORDER BY prezzo ASC";
                    }
                    else if($categoria["ordinamento"]=="Per prezzo, decrescente") {
                        $ordinamento = "ORDER BY prezzo DESC";
                    }
                    else {
                        $ordinamento = "";
                    }
		        
                    $querySottoCategoria = "SELECT * FROM geec_categorie WHERE tipo LIKE 'ecommerce' AND categoriaMadre='{$categoria["id"]}'";
                    $risSottoCategoria   = parent::getDb()->eseguiQueryLettura($querySottoCategoria);
                    
                    $stringaCat = "AND (categoria='{$categoria["id"]}' ";
                    $this->stringaSottoCategorie = "";

                    if($risSottoCategoria->num_rows>0) {
                       $this->stringaSottoCategorie .= "<div class=\"form-row sottocategorie mb-2\">";
                    }
                    while($sottoCategoria=$risSottoCategoria->fetch_assoc()) {

                        $link = GeneratoreUrl::creaUrlCategoria($sottoCategoria,$impostazioniAspetto["ottimizzazioneUrl"],$impostazioniAspetto["urlSito"]);
                        
                        if($sottoCategoria["foto"]!="") {
		                $codiceSingolaSottoCategoria = "<div class=\"col-4 col-sm-3 col-xl-2 text-center mb-3\">
								    <a class=\"d-block pb-2 border-bottom border-primary\" href=\"$link\"><div class=\"background-image aspect-ratio-1-1 mb-2\" style=\"background: url('{$sottoCategoria["foto"]}');\">&nbsp;</div>
								      <strong>{$sottoCategoria["nome"]}</strong>
								    </a>
								  </div>";
                        }
                        else {
		            	 $codiceSingolaSottoCategoria = "<a class=\"btn btn-outline-primary mb-2 ml-2\" href=\"$link\" > {$sottoCategoria["nome"]}</a>";
                        }
                    	 $this->stringaSottoCategorie .= $codiceSingolaSottoCategoria;

                        $stringaCat .=" OR categoria={$sottoCategoria["id"]}";
                        //esegue una query simile per prendere le sottocategorie della sottocategoria
                        $querySottoCategorie = "SELECT * FROM geec_categorie WHERE categoriaMadre='{$sottoCategoria["id"]}'";
                        $risSottoCategoriaDellaSottocategoria = parent::getDb()->eseguiQueryLettura($querySottoCategorie);
                        while($sottoCategoriaDellaSottocategoria = $risSottoCategoriaDellaSottocategoria->fetch_assoc()) {
                            $stringaCat .=" OR categoria={$sottoCategoriaDellaSottocategoria["id"]}";
                        }
                    }
                    $stringaCat .=" )";
                    if($risSottoCategoria->num_rows>0) {
                        $this->stringaSottoCategorie .= "</ul></div>";
                    }
                    $queryRicerca = "SELECT * FROM geecEc_prodotti WHERE pubblicato LIKE 'si' $stringaCat $ordinamento";
                    parent::setQueryConteggio($queryRicerca);

                    // aggiungo la limitazione del sito
                    if(isset($_GET["pag"])) {
                        $limiteInferiore = $categoria["numeroArticoliPerPagina"] * ($_GET["pag"] -1);
                        $queryRicerca .= " LIMIT $limiteInferiore, {$categoria["numeroArticoliPerPagina"]}";
                    }
                    else {
                        $queryRicerca .= " LIMIT {$categoria["numeroArticoliPerPagina"]}";
                    }
                    parent::setQueryRicerca($queryRicerca);
                }
                else {
                    parent::generaQuery();
                }
            }
            else {
                parent::generaQuery();
            }
        }

        function stampaContenuti($configurazioneAspetto) {
            $impostazioniAspetto = parent::getImpostazioniAspetto();
            
            // controllo se l'utente appartiene a un gruppo specifico, in caso affermativo salvo i dati che verranno
            // passati alla funzione che stampa il prodotto
            if(isset($_SESSION["geecomUser_idGruppo"]) && $_SESSION["geecomUser_idGruppo"]!=0) {
                $datiGruppo = parent::getDb()->leggiSingolaRiga("geecAd_gruppi",$_SESSION["geecomUser_idGruppo"]);
            }
            else {
                $datiGruppo = null;
            }
            
            $impostazioniEcommerce = parent::getDb()->leggiSingolaRiga("geecEc_impostazioni",1);
            if($impostazioniEcommerce["posizioneBarraLaterale"]=="sinistra") {
                $classeColonnaPrincipale = "order-md-1";
            }
            else {
                $classeColonnaPrincipale = "order-md-0";
            }
            
            if($impostazioniEcommerce["posizioneBarraLaterale"]=="sinistra") {
                $classeColonnaLaterale = "order-md-0";
            }
            else {
                $classeColonnaLaterale = "order-md-1";
            }
                
            if($impostazioniEcommerce["bloccaAcquisti"]=="si") {
                $stampaPulsante = false; 
            }
            else {
                $stampaPulsante = true;
            }
            
            if(parent::getTipo()=="categoria") {
                $categoria = parent::getChiaveRicerca();
                if($categoria["tipo"]=="ecommerce") {
                    $classiAggiuntiveSezione =  ($categoria["tipoVisualizzazione"]=="presentazione") ? "articoli-dal-blog prodotti-dal-negozio" : "";
                    $classiAggiuntiveDivContenitoreRisultati =  ($categoria["tipoVisualizzazione"]=="presentazione") ? "articoli-dal-blog" : "prodotti-dal-negozio";
                    echo"<section class=\"ecommerce $classiAggiuntiveSezione siOverflow\">
                            <div class=\"container\">
                                <div class=\"row\">
                                    <div class=\"{$configurazioneAspetto['colonnaCentrale']} $classeColonnaPrincipale\">";
                                        echo $this->stringaSottoCategorie;
                                        echo"<div class=\"mb-3\">";
                                        echo $this->getTitoloPagina();
                                        echo"</div>";
                                        echo"<div class=\"row $classiAggiuntiveDivContenitoreRisultati\">";
                                        while($prodotto = parent::getRisultatiRicerca()->fetch_assoc()) {
                                            $linkProdotto  = GeneratoreUrl::creaUrlProdotto($prodotto, $impostazioniAspetto["ottimizzazioneUrl"], $impostazioniAspetto["urlSito"]);
                                            $categoriaProdotto = parent::getDb()->leggiSingolaRiga("geec_categorie",$prodotto["categoria"]);
                                            $linkCategoria = GeneratoreUrl::creaUrlCategoria($categoriaProdotto, $impostazioniAspetto["ottimizzazioneUrl"], $impostazioniAspetto["urlSito"]);

                                            if($categoria["tipoVisualizzazione"]=="background") {
                                                StampaContenuti::stampaProdottoImgBackground(parent::getGestoreTraduzioni(),$impostazioniEcommerce, $prodotto, $linkProdotto, $categoriaProdotto, $linkCategoria,"col-lg-4 d-flex mb-4",$datiGruppo,true,$stampaPulsante);
                                            }
                                            else if($categoria["tipoVisualizzazione"]=="classico"){
                                                StampaContenuti::stampaProdottoSenzaImgBackground(parent::getGestoreTraduzioni(),$impostazioniEcommerce, $prodotto, $linkProdotto, $categoriaProdotto, $linkCategoria,"col-lg-4 d-flex mb-4",$datiGruppo,true,$stampaPulsante);
                                            }
                                            else {
                                                StampaContenuti::stampaProdottoConDescrizioneBreve(parent::getGestoreTraduzioni(),$impostazioniEcommerce, $prodotto, $linkProdotto, $categoriaProdotto, $linkCategoria,"col-12",$datiGruppo,$stampaPulsante);
                                            }
                                        }
                                        $this->numeroRisultatiRicerca = parent::getNumeroRisultatiRicerca();
                                    echo"</div>";
                                    parent::stampaPaginazione();
                                echo"</div>";
                                if($configurazioneAspetto["attivaColonnaDestra"]=="si") {
                                    VisualizzatorePannelloLaterale::stampa(parent::getDb(), $impostazioniAspetto, $configurazioneAspetto,"destra",$impostazioniAspetto["linguaSito"]);
                                }
                                echo"</div>";
                          echo"</div>"
                     . "</section>";
                }
                else {
                    parent::stampaContenuti($configurazioneAspetto);
                }
            }
            else if(parent::getTipo()=="cercaProdotti") {
                $impostazioniEcommerce = parent::getDb()->leggiSingolaRiga("geecEc_impostazioni",1);
                if($impostazioniEcommerce["posizioneBarraLaterale"]=="sinistra") {
                    $classeColonnaPrincipale = "order-md-1";
                }
                else {
                    $classeColonnaPrincipale = "order-md-0";
                }

                if($impostazioniEcommerce["posizioneBarraLaterale"]=="sinistra") {
                    $classeColonnaLaterale = "order-md-0";
                }
                else {
                    $classeColonnaLaterale = "order-md-1";
                }

                if($impostazioniEcommerce["bloccaAcquisti"]=="si") {
                    $stampaPulsante = false; 
                }
                else {
                    $stampaPulsante = true;
                }
                
                echo"<section class=\"ecommerce siOverflow\">
                          <div class=\"container\">
                            <div class=\"row\">
                                <div class=\"{$configurazioneAspetto['colonnaCentrale']} $classeColonnaPrincipale \">";
                                  echo"<div class=\"mb-3\">";
                                  echo $this->getTitoloPagina();
                                  echo"</div>";
                                  echo"<div class=\"row prodotti-dal-negozio\">";
                                  while($prodotto = parent::getRisultatiRicerca()->fetch_assoc()) {
                                    $linkProdotto  = GeneratoreUrl::creaUrlProdotto($prodotto, $impostazioniAspetto["ottimizzazioneUrl"], $impostazioniAspetto["urlSito"]);
                                    $categoriaProdotto = parent::getDb()->leggiSingolaRiga("geec_categorie",$prodotto["categoria"]);
                                    $linkCategoria = GeneratoreUrl::creaUrlCategoria($categoriaProdotto, $impostazioniAspetto["ottimizzazioneUrl"], $impostazioniAspetto["urlSito"]);

                                    if($categoriaProdotto["tipoVisualizzazione"]=="background") {
                                        StampaContenuti::stampaProdottoImgBackground(parent::getGestoreTraduzioni(),$impostazioniEcommerce, $prodotto, $linkProdotto, $categoriaProdotto, $linkCategoria,"col-lg-4 d-flex mb-4",$datiGruppo,true,$stampaPulsante);
                                    }
                                    else {	
                                        StampaContenuti::stampaProdottoSenzaImgBackground(parent::getGestoreTraduzioni(),$impostazioniEcommerce, $prodotto, $linkProdotto, $categoriaProdotto, $linkCategoria,"col-lg-4 d-flex mb-4",$datiGruppo,true,$stampaPulsante);
                                    }
                                  }
                                  $this->numeroRisultatiRicerca = parent::getNumeroRisultatiRicerca();
                                echo"</div>";
                                parent::stampaPaginazione();
                            echo"</div>";
                            if($configurazioneAspetto["attivaColonnaDestra"]=="si") {
                                VisualizzatorePannelloLaterale::stampa(parent::getDb(), $impostazioniAspetto, $configurazioneAspetto,"destra",$impostazioniAspetto["linguaSito"]);
                            }
                            echo"</div>";
                      echo"</div>"
                 . "</section>";
            }
            else if(parent::getTipo()=="cercaProdottiFornitore") {
                $impostazioniEcommerce = parent::getDb()->leggiSingolaRiga("geecEc_impostazioni",1);
                 echo"<section class=\"ecommerce siOverflow\">
                          <div class=\"container\">
                            <div class=\"row\">
                                <div class=\"{$configurazioneAspetto['colonnaCentrale']} $classeColonnaPrincipale \">";
                                  echo $this->getTitoloPagina();
                                  echo"<div class=\"row prodotti-dal-negozio\">";
                                  while($prodotto = parent::getRisultatiRicerca()->fetch_assoc()) {
                                    $linkProdotto  = GeneratoreUrl::creaUrlProdotto($prodotto, $impostazioniAspetto["ottimizzazioneUrl"], $impostazioniAspetto["urlSito"]);
                                    $categoriaProdotto = parent::getDb()->leggiSingolaRiga("geec_categorie",$prodotto["categoria"]);
                                    $linkCategoria = GeneratoreUrl::creaUrlCategoria($categoriaProdotto, $impostazioniAspetto["ottimizzazioneUrl"], $impostazioniAspetto["urlSito"]);

                                    if($categoria["tipoVisualizzazione"]=="background") {
                                        StampaContenuti::stampaProdottoImgBackground(parent::getGestoreTraduzioni(),$impostazioniEcommerce, $prodotto, $linkProdotto, $categoria, $linkCategoria,"col-lg-4 d-flex mb-4",$datiGruppo,$stampaPulsante);
                                    }
                                    else {	
                                        StampaContenuti::stampaProdottoSenzaImgBackground(parent::getGestoreTraduzioni(),$impostazioniEcommerce, $prodotto, $linkProdotto, $categoria, $linkCategoria,"col-lg-4 d-flex mb-4",$datiGruppo,$stampaPulsante);
                                    }
                                  }
                                  $this->numeroRisultatiRicerca = parent::getNumeroRisultatiRicerca();
                                echo"</div>";
                                parent::stampaPaginazione();
                            echo"</div>";
                            if($configurazioneAspetto["attivaColonnaDestra"]=="si") {
                                VisualizzatorePannelloLaterale::stampa(parent::getDb(), $this->impostazioniAspetto, $configurazioneAspetto,"destra",$this->impostazioniAspetto["linguaSito"]);
                            }
                            echo"</div>";
                      echo"</div>"
                 . "</section>";
	    }
	    else if(parent::getTipo()=="cercaProdottiPerMarca") {
                $impostazioniEcommerce = parent::getDb()->leggiSingolaRiga("geecEc_impostazioni",1);
                 echo"<section class=\"ecommerce siOverflow\">
                          <div class=\"container\">
                            <div class=\"row\">
                                <div class=\"{$configurazioneAspetto['colonnaCentrale']} $classeColonnaPrincipale \">";
                                  echo $this->getTitoloPagina();
                                  echo"<div class=\"row prodotti-dal-negozio\">";
                                  while($prodotto = parent::getRisultatiRicerca()->fetch_assoc()) {
                                    $linkProdotto  = GeneratoreUrl::creaUrlProdotto($prodotto, $impostazioniAspetto["ottimizzazioneUrl"], $impostazioniAspetto["urlSito"]);
                                    $categoriaProdotto = parent::getDb()->leggiSingolaRiga("geec_categorie",$prodotto["categoria"]);
                                    $linkCategoria = GeneratoreUrl::creaUrlCategoria($categoriaProdotto, $impostazioniAspetto["ottimizzazioneUrl"], $impostazioniAspetto["urlSito"]);

                                    if($categoria["tipoVisualizzazione"]=="background") {
                                        StampaContenuti::stampaProdottoImgBackground(parent::getGestoreTraduzioni(),$impostazioniEcommerce, $prodotto, $linkProdotto,$categoria, $linkCategoria,"col-lg-4 d-flex mb-4",$datiGruppo,$stampaPulsante);
                                    }
                                    else {	
                                        StampaContenuti::stampaProdottoSenzaImgBackground(parent::getGestoreTraduzioni(),$impostazioniEcommerce, $prodotto, $linkProdotto,$categoria, $linkCategoria,"col-lg-4 d-flex mb-4",$datiGruppo,$stampaPulsante);
                                    }
                                  }
                                  $this->numeroRisultatiRicerca = parent::getNumeroRisultatiRicerca();
                                echo"</div>";
                                parent::stampaPaginazione();
                            echo"</div>";
                            if($configurazioneAspetto["attivaColonnaDestra"]=="si") {
                                VisualizzatorePannelloLaterale::stampa(parent::getDb(), $this->impostazioniAspetto, $configurazioneAspetto,"destra",$this->impostazioniAspetto["linguaSito"]);
                            }
                            echo"</div>";
                      echo"</div>"
                 . "</section>";
	    }
	    else if(parent::getTipo()=="prodottiPerMarcaECategoria") {
                $marca     = filter_input(INPUT_GET,"marca",FILTER_SANITIZE_ADD_SLASHES);
                $categoria = parent::getChiaveRicerca();
                $classiAggiuntiveSezione =  ($categoria["tipoVisualizzazione"]=="presentazione") ? "articoli-dal-blog prodotti-dal-negozio" : "";
                $classiAggiuntiveDivContenitoreRisultati =  ($categoria["tipoVisualizzazione"]=="presentazione") ? "articoli-dal-blog" : "prodotti-dal-negozio";
                echo"<section class=\"ecommerce $classiAggiuntiveSezione siOverflow\">
                            <div class=\"container\">
                                <div class=\"row\">
                                    <div class=\"{$configurazioneAspetto['colonnaCentrale']} $classeColonnaPrincipale\">";
                                        echo $this->stringaSottoCategorie;
                                        echo"<div class=\"mb-3\">";
                                        echo $this->getTitoloPagina();
                                        echo"</div>";
                                        echo"<div class=\"row $classiAggiuntiveDivContenitoreRisultati\">";
                                        while($prodotto = parent::getRisultatiRicerca()->fetch_assoc()) {
                                            $categoriaProdotto = parent::getDb()->leggiSingolaRiga("geec_categorie",$prodotto["categoria"]);
                                            $linkCategoria = GeneratoreUrl::creaUrlCategoria($categoriaProdotto, $impostazioniAspetto["ottimizzazioneUrl"], $impostazioniAspetto["urlSito"]);

                                            if($categoria["tipoVisualizzazione"]=="background") {
                                                StampaContenuti::stampaProdottoImgBackground(parent::getGestoreTraduzioni(),$impostazioniEcommerce, $prodotto, $categoriaProdotto, $linkCategoria,"col-lg-4 d-flex mb-4",$datiGruppo,true,$stampaPulsante);
                                            }
                                            else if($categoria["tipoVisualizzazione"]=="classico"){	
                                                StampaContenuti::stampaProdottoSenzaImgBackground(parent::getGestoreTraduzioni(),$impostazioniEcommerce, $prodotto, $categoriaProdotto, $linkCategoria,"col-lg-4 d-flex mb-4",$datiGruppo,true,$stampaPulsante);
                                            }
                                            else {
                                                StampaContenuti::stampaProdottoConDescrizioneBreve(parent::getGestoreTraduzioni(),$impostazioniEcommerce, $prodotto, $categoriaProdotto, $linkCategoria,"col-12",$datiGruppo,$stampaPulsante);
                                            }
                                        }
                                        $this->numeroRisultatiRicerca = parent::getNumeroRisultatiRicerca();
                                    echo"</div>";
                                    parent::stampaPaginazione("&marca=$marca");
                                echo"</div>";
                                if($configurazioneAspetto["attivaColonnaDestra"]=="si") {
                                    VisualizzatorePannelloLaterale::stampa(parent::getDb(), $impostazioniAspetto, $configurazioneAspetto,"destra",$impostazioniAspetto["linguaSito"]);
                                }
                                echo"</div>";
                echo"</div>"
                . "</section>";
            }
            else {
                parent::stampaContenuti($configurazioneAspetto);
            }
	 }

        function getTitoloPagina() {
            if(parent::getTipo()=="categoria") {
                $categoria = parent::getChiaveRicerca();
                if($categoria["tipo"] == "ecommerce") {
                    return "<p class=\"text-muted\">".parent::getNumeroRisultatiRicerca()." prodotti nella categoria  <strong>{$categoria["nome"]}</strong></p>";
                }
                else {
                    return "<p class=\"text-muted\">".parent::getNumeroRisultatiRicerca()." articoli nella categoria  <strong>{$categoria["nome"]}</strong></p>";
                }
            }
            else if(parent::getTipo()=="prodottiPerMarcaECategoria") {
                $marca     = filter_input(INPUT_GET,"marca",FILTER_SANITIZE_ADD_SLASHES);
                $categoria = parent::getChiaveRicerca();
                return "<p class=\"text-muted\">".parent::getNumeroRisultatiRicerca()." prodotti per la categoria <strong>{$categoria["nome"]}</strong> e marca <strong>$marca</strong></p>";
            }
            else if(parent::getTipo()=="cercaProdotti") {
                return "<p class=\"text-muted\">".parent::getNumeroRisultatiRicerca()." prodotti per la parola chiave <strong>".parent::getChiaveRicerca()."</strong></p>";
            }
            else if(parent::getTipo()=="cercaProdottiFornitore") {
                return "<p class=\"text-muted\">".parent::getNumeroRisultatiRicerca()." prodotti del fornitore: <strong>".parent::getChiaveRicerca()."</strong></p>";
            }
            else if(parent::getTipo()=="cercaProdottiPerMarca") {
                return "<p class=\"text-muted\">".parent::getNumeroRisultatiRicerca()." prodotti per marca: <strong>".parent::getChiaveRicerca()."</strong></p>";
            }
            else {
                parent::getTitoloPagina();
            }
        }
    }
